IF EXISTS(SELECT *	FROM SYS.PROCEDURES	WHERE NAME = 'P_LGPD_PROCESSAMENTO_SNGPC')
    BEGIN
        DROP PROCEDURE P_LGPD_PROCESSAMENTO_SNGPC;
    END;
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: P_LGPD_PROCESSAMENTO_SNGPC 
'Objetivo............: Procedure responsavel pela anonimizao de SNGPC - LGPD 
'Tabelas.............: GLB_USU_EST_SNGPC, LGPD_LOG_PROCESSAMENTO
'Dt Criao..........: 
'Dt Ult Alteraco....: 
'Alterado por........: 
'Criado por..........: Rayane
'=======================================================================================
*/

CREATE PROCEDURE P_LGPD_PROCESSAMENTO_SNGPC(@SNGPC INT)
WITH ENCRYPTION
AS
    SET NOCOUNT ON;
    PRINT 'ANONIMIZANDO SNGPC';

    UPDATE GLB_USU_EST_SNGPC
       SET 
           CPF = '000000000000', 
           LOGIN_ANVISA = 'ANONIMIZADO@ANONIMIZADO', 
           SENHA_ANVISA = ''
    WHERE CD_USU = @SNGPC;


    INSERT INTO LGPD_LOG_PROCESSAMENTO(CD_PESSOA, DT_CAD, NM_FM, TP_PROC)
    SELECT @SNGPC AS CD_CLI, 
            GETDATE() AS DT_CAD, 
            'P_LGPD_PROCESSAMENTO_SNGPC' AS NM_FM, 
            4 AS TP_PROC;